// the below defines turn on and off features
// turing them all on will probably cause complimation to fail with a too many instructions error

// #define TEXTUREBG
// #define BORDER_ON_HIGHLIGHT
#define RMS
// #define BAR_VISIBLE

// #define GRAY
// #define SEPIA
#define CSHIFT

Texture1D tex : WAVEFORMDATA;

sampler sTex = sampler_state
{
	Texture = <tex>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	
    AddressU = Clamp;
};

#ifdef TEXTUREBG
Texture2D bgTex < string ResourceName = "074.jpg"; >;
Texture2D seekTex < string ResourceName = "seekbar.png"; >;

sampler sTexBg = sampler_state
{
	Texture = <bgTex>;	
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = Wrap;
	AddressV = Wrap;
};
#endif

struct VS_IN
{
	float2 pos : POSITION;
	float2 tc : TEXCOORD0;
};

struct PS_IN
{
	float4 pos : SV_POSITION;
	float2 tc : TEXCOORD0;
};


float4 backgroundColor : BACKGROUNDCOLOR;
float4 highlightColor  : HIGHLIGHTCOLOR;
float4 selectionColor  : SELECTIONCOLOR;
float4 textColor       : TEXTCOLOR;
float cursorPos        : CURSORPOSITION;
bool cursorVisible     : CURSORVISIBLE;
float seekPos          : SEEKPOSITION;
bool seeking           : SEEKING;
float4 replayGain      : REPLAYGAIN; // album gain, track gain, album peak, track peak
float2 viewportSize    : VIEWPORTSIZE;
bool horizontal        : ORIENTATION;
bool shade_played      : SHADEPLAYED;

PS_IN VS( VS_IN input )
{
	PS_IN output = (PS_IN)0;

	float2 half_pixel = float2(1,-1) / viewportSize;
	output.pos = float4(input.pos - half_pixel, 0, 1);
	if (horizontal)
		output.tc = float2((input.tc.x + 1.0) / 2.0, input.tc.y);
	else
		output.tc = float2((-input.tc.y + 1.0) / 2.0, input.tc.x);

	return output;
}

float4 bar( float pos, float2 tc, float4 fg, float4 bg, float width, bool show )
{
	float dist = abs(pos - tc.x);
	float4 c = (show && dist < width)
		? lerp(fg, bg, smoothstep(0, width, dist))
		: bg;
	return c;
}

float4 faded_bar( float pos, float2 tc, float4 fg, float4 bg, float width, bool show, float vert_from, float vert_to )
{
	float dist = abs(pos - tc.x);
	float fluff = smoothstep(vert_from, vert_to, abs(tc.y));
	float4 c = show
		? lerp(fg, bg, max(fluff, smoothstep(0, width, dist)))
		: bg;
	return c;
}

// by foosion

float4 grayscale( float4 color )
{
	return color.r * 0.3 + color.g * 0.19 + color.b * 0.11;
}

// by PurpleMonkey
float4 colourshift( float4 color )
{
	float4 newcolor;
	newcolor.r = color.g;
	newcolor.b = color.r;
	newcolor.g = color.b;
	newcolor.a = color.a;
	return newcolor;
}

// by foosion
float4 sepia( float4 color )
{
	float4 weight;
	weight.r = 0.3;
	weight.g = 0.59;
	weight.b = 0.11;
	weight.a = 0;
	
	float4 adjust;
	adjust.r = 0.098039215686275;
	adjust.g = -0.050980392156863;
	adjust.b = -0.26274509803922;
	adjust.a = 0;
	
	float intensity = dot(color, weight)	;
	color = intensity + adjust;
	return saturate(color);
}

float4 contrast( float4 color, float strength )
{
	return saturate((color - 0.5) * strength + 0.5);
}




float4 played( float pos, float2 tc, float4 fg, float4 bg, float alpha)
{
	float4 c = bg;
	float2 d = 1 / viewportSize;
	if (pos > tc.x)
	{
	#ifdef BORDER_ON_HIGHLIGHT
		if (tc.x < d.x || tc.y >= (1 - d.y) || tc.y <= (2 * d.y - 1))
			c = selectionColor;
		else
	#endif
			#ifndef GRAY
			#ifndef SEPIA
			#ifndef CSHIFT
			c = lerp(c, fg, saturate(alpha));
			#endif
			#endif
			#endif
			
			#ifdef GRAY
			c = grayscale(c);
			#endif
			#ifdef SEPIA
			c = sepia(c);
			#endif
			#ifdef CSHIFT
			c = colourshift(c);
			#endif
	}
	return c;
}

// #RMS parts by foosion
// #update and added ifdef -- PurpleMonkey

float4 evaluate( float2 tc , float border )
{
	// alpha 1 indicates biased texture
	float4 minmaxrms = tex.Sample(sTex, tc.x);
	minmaxrms.rgb -= 0.5 * minmaxrms.a;
	minmaxrms.rgb *= 1.0 + minmaxrms.a;
	
#ifdef RMS
	float below = tc.y + border - minmaxrms.r;
	float above = tc.y - border - minmaxrms.g;
#else
	float below = tc.y - minmaxrms.r;
	float above = tc.y - minmaxrms.g;
#endif

	float factor = min(abs(below), abs(above));
	bool outside = (below < 0 || above > 0);

#ifdef RMS
	float diff_rms = abs(tc.y) - border - minmaxrms.b;
	float factor_rms = abs(diff_rms);
	bool inside_rms = diff_rms < 0;
	float factor_A = inside_rms ? (1.0 - 0.5 * saturate(factor_rms / border / 2)): 1.0;
	factor = !outside ? (factor_A * saturate(factor / border / 2)) : 0.0;
#else
	bool inside_rms = abs(tc.y) <= minmaxrms.b;
#endif

#if TEXTUREBG
	float a = viewportSize.x / viewportSize.y;
	float2 aspect = horizontal ? float2(a, 1) : float2(1/a, 1);
	float2 tcBg = float2(tc.x, -tc.y / 2 + 0.5) * aspect;
	float4 bgColor = tex2D(sTexBg, tcBg);
#else
	float4 bgColor = backgroundColor;
#endif

	float4 wave = outside
		? bgColor
		: lerp(bgColor, textColor, 7.0 * factor);

	return saturate(wave);
}

float4 PS( PS_IN input ) : SV_Target
{
	float dx, dy;
	if (horizontal)
	{
		dx = 1/viewportSize.x;
		dy = 1/viewportSize.y;
	}
	else
	{
		dx = 1/viewportSize.y;
		dy = 1/viewportSize.x;
	}
	float seekWidth = 2.5 * dx;
	float positionWidth = 2.5 * dx;

	float4 c0 = evaluate(input.tc, 2.5 * dy);
#ifdef BAR_VISIBLE
	c0 = bar(cursorPos, input.tc, selectionColor, c0, positionWidth, cursorVisible);
	c0 = bar(seekPos,   input.tc, selectionColor, c0, seekWidth,     seeking      );
#endif
	if (shade_played)
		c0 = played(cursorPos, input.tc, highlightColor, c0, 0.3);
	return c0;
}

technique10 Render10
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

technique Render9
{
	pass
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}
