// ========================================
// PLaylist Tab Manager by Br3tt - 04/2010
// ========================================

//=================================================// Images directory
var img_dir = fb.FoobarPath + "skins\\tech\\images\\";

//=================================================// Images
var btclosetab0 = "btclosetab0.png";
var btclosetab1 = "btclosetab1.png";

// Use with GdiDrawText() 
// {{
var DT_LEFT = 0x00000000;
var DT_RIGHT = 0x00000002;
var DT_TOP = 0x00000000;
var DT_CENTER = 0x00000001;
var DT_VCENTER = 0x00000004;
var DT_WORDBREAK = 0x00000010;
var DT_CALCRECT = 0x00000400;
var DT_NOPREFIX = 0x00000800;
var DT_END_ELLIPSIS = 0x00008000;
// }}

var ButtonStates = {
    normal: 0,
    hover: 1,
    down: 2
};
var TabStates = {
    normal: 0,
    hover: 1,
    down: 2
};

//=================================================// Tools
function RGB(r, g, b) {
    return (0xff000000 | (r << 16) | (g << 8) | (b));
}

function RGBA(r, g, b, a) {
    return ((a << 24) | (r << 16) | (g << 8) | (b));
}

//Text formatting function
function StringFormat() {
    var h_align = 0,
        v_align = 0,
        trimming = 0,
        flags = 0;
    switch (arguments.length) {
            // fall-thru
        case 4:
            flags = arguments[3];
        case 3:
            trimming = arguments[2];
        case 2:
            v_align = arguments[1];
        case 1:
            h_align = arguments[0];
            break;
        default:
            return 0;
        }
    return ((h_align << 28) | (v_align << 24) | (trimming << 20) | flags);
}

StringAlignment = {
    Near: 0,
    Centre: 1,
    Far: 2
};

var l_stringformat = StringFormat(StringAlignment.Near, StringAlignment.Centre);
var c_stringformat = StringFormat(StringAlignment.Centre, StringAlignment.Centre);
var r_stringformat = StringFormat(StringAlignment.Far, StringAlignment.Centre);

//=================================================// OBJECT tab
tab = function () {
    this.TabStates = {
        normal: 0,
        hover: 1,
        down: 2
    };
    this.font = gdi.Font("segoe ui", 10, 1);
    var i;

    this.create = function (tabname, id) {
        if (typeof this.tabname == "undefined") {
            this.tabname = tabname;
            if (fb.ActivePlaylist == id) {
                this.status = 1;
            } else {
                this.status = 0;
            }
            // ----<
            this.x = 0;
            this.y = 0;
            this.w = 0;
            this.h = 0;
            this.state = 0;
            // creating the close tab button of this sheet
            this.bt_close = new button;
            this.bt_close.create(img_dir + btclosetab0, img_dir + btclosetab0, img_dir + btclosetab1, "", 0);
        }
    }

    this.draw = function (gr, bx, by, alpha, id) {
        var image;
        var label_colour;

        this.w = CONST_tab_width;
        this.h = CONST_tab_height;
        this.x = CONST_tab_left_padding + bx + ((this.w + 1) * id);
        this.y = by;

        switch (this.state) {
        case 0:
            label_colour = RGBA(110, 110, 110, 255);
            break;
        case 1:
            label_colour = RGBA(160, 160, 160, 255);
            break;
        case 2:
            label_colour = RGBA(255, 055, 055, 255);
            break;
        }

        // Drawing a tab
        if (fb.ActivePlaylist == id) {
            label_colour = RGBA(150, 140, 060, 255);
            gr.FillGradRect(this.x, this.y, this.w - 1, this.h - 1, 90, RGBA(10, 10, 10, 255), RGBA(45, 45, 45, 255));
        } else {
            gr.FillGradRect(this.x, this.y, this.w - 1, this.h - 1, 90, RGBA(45, 45, 45, 255), RGBA(10, 10, 10, 255));
        }
        gr.GdiDrawText(this.tabname, this.font, label_colour, this.x + 4, this.y + 4, this.w - 21 - 1, this.h, DT_END_ELLIPSIS);

        // Drawing the close tab button in the tab (only is there are more than 1 sheet !)
        this.bt_close.draw(gr, Math.floor(this.x + this.w - 12), this.y + 3, (this.status == 0 && this.state == 0) ? 075 : 255, "");

    }

    this.checkstate = function (event, x, y, id) {
        switch (event) {
        case "down":
            // check if tab is clicked?
            if (this.state != TabStates.down && x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h) {
                this.state = TabStates.down;
                window.Repaint();
            } else if (this.state == TabStates.down) {
                this.state = TabStates.normal;
                window.Repaint();
            }
            break;
        case "right":
            if (x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h) {
                playlist_context_menu(x, y, id);
            }
            break;
        case "up":
            // check if tab is clicked?
            if (fb.ActivePlaylist != id && x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h) {
                // changing state of the tab
                this.state = TabStates.normal;
                // changing the activesheet # of the active book
                for(i=0;i<mytab.length;i++)
                {
                    mytab[i].status=0;
                }
                this.status = 1;
                fb.ActivePlaylist = id;
                this.state = TabStates.hover;
                window.Repaint();
            } else {
                this.state = TabStates.normal;
            }
            break;
        case "move":
            if(x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h){
                this.is_over=true;
            } else {
                this.is_over=false;
            }
            // check if tab is hover?
            if (this.state != TabStates.hover && x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h) {
                this.state = TabStates.hover;
                window.Repaint();
            } else if (this.state == TabStates.hover && x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h) {

            } else {
                this.state = TabStates.normal;
            }
            break;
        case "leave":
            this.state = TabStates.normal;
            window.Repaint();
            break;
        }
        return this.state;
    }
}

//=================================================// Global Variables
// Buttons global variables
var mybutton = Array(new button, new button, new button, new button);
var buttons_padx = 0;
var buttons_pady = 0;

// Tabs global variables
var mytab = Array(new tab);
var tabs_padx = 0;
var tabs_pady = 1;
var CONST_tab_width = 130;
var CONST_tab_width_default = 130;
var CONST_tab_width_minimal = 85;
var CONST_tab_height = 20;
var CONST_tab_left_padding = 00;
var CONST_tab_right_padding = 18;
var CONST_new_tab_button_width = 19;
var CONST_scroll_button_width = 18;
var scrolltabs;

var pos;
var bt_w = CONST_tab_width_minimal + 1;
var scrollstep = (bt_w + 1) / 2;

var tooltip = window.CreateTooltip();

// Common global variables
var ww = window.Width;
var wh = window.Height;
var mouse_x;
var mouse_y;
var show_tooltip;
var hand;

//==========================================================================/ on_paint
function on_paint(gr) {
    var i;
    // background
    gr.FillSolidRect(0, 0, ww, wh, RGBA(0, 0, 0, 255));
    gr.DrawLine(0,0,ww,0,1.0,RGBA(20, 22, 25, 255));
    gr.FillGradRect(0, 2, ww, wh-3, 90, RGB(000, 000, 000), RGB(20, 20, 20));
    
    // draw the tabs
    for (i = 0; i < mytab.length; i++) {
        mytab[i].draw(gr, pos + tabs_padx, tabs_pady, 255, i);
    }

    //draw buttons
    if (scrolltabs) {
        gr.FillSolidRect(0, 0, CONST_tab_left_padding, wh, RGB(0, 0, 0));
        gr.FillSolidRect(ww - CONST_tab_right_padding - 1, 0, CONST_tab_right_padding + 1, wh, RGB(0, 0, 0));
    }
    for (i = 0; i < mybutton.length; i++) {
        switch (i) {
        case 0:
            // Add a new playlist
            if (scrolltabs) {
                mybutton[i].draw(gr, ww - CONST_tab_right_padding + CONST_scroll_button_width, buttons_pady+1, 255, (typeof mybutton[i].text == "undefined" ? "" : mybutton[i].text));
            } else {
                mybutton[i].draw(gr, pos + CONST_tab_left_padding + tabs_padx + (mytab.length * (CONST_tab_width + 1)) + 1, buttons_pady+1, 255, (typeof mybutton[i].text == "undefined" ? "" : mybutton[i].text));
            }
            break;
        case 1:
            // Playlist list
            mybutton[i].draw(gr, ww - mybutton[i].w + 0, buttons_pady+1, 255, (typeof mybutton[i].text == "undefined" ? "" : mybutton[i].text));
            break;
        case 2:
            // scroll playlists to left
            if (scrolltabs) {
                mybutton[i].draw(gr, 0, buttons_pady+1, 255, (typeof mybutton[i].text == "undefined" ? "" : mybutton[i].text));
            }
            break;
        case 3:
            // scroll playlists to right
            if (scrolltabs) {
                mybutton[i].draw(gr, ww - CONST_tab_right_padding, buttons_pady+1, 255, (typeof mybutton[i].text == "undefined" ? "" : mybutton[i].text));
            }
            break;
        }
    }
}

//==========================================================================/ on_size
function on_size() {
    var i;
    var nb_playlists_stock;

    ww = window.Width;
    wh = window.Height;

    pos = 0;

    buttons_padx = 0;
    buttons_pady = 0;

    refresh_playlists();

    // initialize button's attributs
    for (i = 0; i < mybutton.length; i++) {
        switch (i) {
        case 0:
            mybutton[i].create(img_dir + "bt_addpl0.png", img_dir + "bt_addpl0.png", img_dir + "bt_addpl1.png", "", i);
            break;
        case 1:
            mybutton[i].create(img_dir + "bt_plopt0.png", img_dir + "bt_plopt0.png", img_dir + "bt_plopt1.png", "", i);
            break;
        case 2:
            mybutton[i].create(img_dir + "bt_leftpl0.png", img_dir + "bt_leftpl0.png", img_dir + "bt_leftpl1.png", "", i);
            break;
        case 3:
            mybutton[i].create(img_dir + "bt_rightpl0.png", img_dir + "bt_rightpl0.png", img_dir + "bt_rightpl1.png", "", i);
            break;
        }
    }
}

//==========================================================================/ playlists_changed
function on_playlists_changed() {
    refresh_playlists();
}

function on_playlist_switch() {
    window.Repaint();
}

//==========================================================================/ lbtn_down
function on_mouse_lbtn_down(x, y) {
    var i;
    for (i = 0; i < mybutton.length; i++) {
        mybutton[i].checkstate("down", x, y, i);
    }

    if (x > CONST_tab_left_padding && x < ww - CONST_tab_right_padding) {
        for (i = 0; i < mytab.length; i++) {
            if (x > mytab[i].bt_close.x + mytab[i].bt_close.w - 12 && x < mytab[i].bt_close.x + mytab[i].bt_close.w - 02 && y > mytab[i].bt_close.y + 3 && y < mytab[i].bt_close.y + 13) {} else {
                mytab[i].checkstate("down", x, y, i);
            }
            mytab[i].bt_close.checkstate("down", x, y, i);
        }
    }
}

//==========================================================================/ lbtn_up
function on_mouse_lbtn_up(x, y) {
    var i;
    var j;
    var active_pl;
    var nb_pl;
    var top_refresh_columns_width = 0;
	var new_pl=false;

    // buttons actions
    for (i = 0; i < mybutton.length; i++) {
        switch (i) {
        case 0:
            if (mybutton[i].checkstate("up", x, y, i) == mybutton[i].ButtonStates.hover) {
                fb.CreatePlaylist(mytab.length, "");
				fb.ActivePlaylist = mytab.length;
				new_pl=true;
            }
            break;
        case 1:
            if (mybutton[i].checkstate("up", x, y, i) == mybutton[i].ButtonStates.hover) {
                playlist_command_menu(x, y, i);
            }
            break;
        case 2:
            if (mybutton[i].checkstate("up", x, y, i) == mybutton[i].ButtonStates.hover) {
                on_mouse_wheel(1);
            }
            break;
        case 3:
            if (mybutton[i].checkstate("up", x, y, i) == mybutton[i].ButtonStates.hover) {
                on_mouse_wheel(-1);
            }
            break;
        }
    }

    if (x > CONST_tab_left_padding && x < ww - CONST_tab_right_padding) {
        for (i = 0; i < mytab.length; i++) {
            if (mytab[i].bt_close.checkstate("up", x, y, i) == ButtonStates.hover) {
                active_pl = fb.ActivePlaylist;
                nb_pl = mytab.length;
                mytab.splice(i,1);
                fb.RemovePlaylist(i);
                //refresh_playlists();
                if (i == active_pl) {
                    if (nb_pl > 1) 
                    {
                        if(i == nb_pl - 1)
                        {
                            fb.ActivePlaylist = i - 1;
                        } else {
                            fb.ActivePlaylist = active_pl;
                        }
                    }
                }
                if (scrolltabs) {
                    pos = pos < CONST_tab_width_minimal * -1 ? pos + CONST_tab_width_minimal + 1 : pos;
                } else {
                    pos = 0;
                }
                refresh_playlists();
            } else {
                mytab[i].checkstate("up", x, y, i);
            }
        }
    }
	
	if(new_pl && scrolltabs) 
	{
		on_mouse_wheel(-1);
	}
}

//==========================================================================/ mouse_move
function on_mouse_move(x, y) {
    mouse_x = x;
    mouse_y = y;

    var i;
    
    hand=false;
    for (i = 0; i < mybutton.length; i++) {
        mybutton[i].checkstate("move", x, y, i);
	if(mybutton[i].is_hover==true) hand=true;
    }

    if (x > CONST_tab_left_padding && x < ww - CONST_tab_right_padding) {
	show_tooltip=false;
        for (i = 0; i < mytab.length; i++) {
            if(mytab[i].checkstate("move", x, y, i)==TabStates.hover)
            {
                show_tooltip = true;
                if(tooltip.Text != mytab[i].tabname) {
			tooltip.Deactivate();
			tooltip.Text = mytab[i].tabname;
		}
            }
            mytab[i].bt_close.checkstate("move", x, y, i);
            if(mytab[i].bt_close.is_hover==true) hand=true;
        }

        if(show_tooltip)
        {
	    tooltip.Activate();
        } else {
            tooltip.Deactivate();
	    tooltip.Text="";
        }

    } else {
        tooltip.Deactivate();
        tooltip.Text="";
    }

    if (hand) {
            this.mousecursor=32649;
    } else {
            this.mousecursor=32512;
    }
    window.SetCursor(this.mousecursor);

}

//==========================================================================/ mouse_leave
function on_mouse_leave() {

    var i;
    for (i = 0; i < mybutton.length; i++) {
        mybutton[i].checkstate("leave", 0, 0, i);
    }

    for (i = 0; i < mytab.length; i++) {
        mytab[i].checkstate("leave", 0, 0, i);
        mytab[i].bt_close.checkstate("leave", 0, 0, i);
    }
    tooltip.Text="";

}

// ==============================================================/ Redraw more than once per sec
function on_timer(id) {
    var i;
    for (i = 0; i < mybutton.length; i++) {
        mybutton[i].ontimer(id);
    }

    for (i = 0; i < mytab.length; i++) {
        mytab[i].bt_close.ontimer(id);
    }
}

// ===============================================================================/ playlist context menu
function playlist_context_menu(x, y, id) {
    var MF_SEPARATOR = 0x00000800;
    var MF_STRING = 0x00000000;
    var _menu = window.CreatePopupMenu();
    var idx;

    _menu.AppendMenuItem(MF_STRING, 1, "Rename this playlist");
    //_menu.AppendMenuItem(MF_STRING, 2, "Save");
    //_menu.AppendMenuItem(MF_STRING, 3, "Properties");
    //_menu.AppendMenuItem(MF_STRING, 4, "Configure...");
    idx = _menu.TrackPopupMenu(x, y);
    switch (idx) {
    case 1:
        playlistname = InputBox("Rename the playlist: "+mytab[id].tabname, "Rename a playlist", mytab[id].tabname);
        if(!playlistname || playlistname == "") playlistname = mytab[id].tabname;
        if (playlistname.length > 1 || (playlistname.length == 1 && (playlistname >= "a" && playlistname <= "z") || (playlistname >= "A" && playlistname <= "Z") || (playlistname >= "0" && playlistname <= "9"))) {
            mytab[id].tabname = playlistname;
            fb.RenamePlaylist(id, playlistname);
            window.Repaint();
        }
        break;
    case 2:
        break;
    case 3:
        window.ShowProperties();
        break;
    case 4:
        window.ShowConfigure();
        break;
    }
    _menu.Dispose();
    return true;
}

// ===============================================================================/ playlist command menu
function playlist_command_menu(x, y, id) {
    var MF_SEPARATOR = 0x00000800;
    var MF_STRING = 0x00000000;
    var _menu = window.CreatePopupMenu();
    var idx;
    var ind;

    ind=fb.ActivePlaylist;

    _menu.AppendMenuItem(MF_STRING, 1, "Rename the active Playlist");
    _menu.AppendMenuItem(MF_STRING, 2, "Save the active Playlist");
    _menu.AppendMenuItem(MF_STRING, 3, "Load a Playlist");
    _menu.AppendMenuItem(MF_STRING, 4, "Playlist Manager");
    //_menu.AppendMenuItem(MF_STRING, 98, "Properties");
    //_menu.AppendMenuItem(MF_STRING, 99, "Configure...");
    idx = _menu.TrackPopupMenu(x, y);
    switch (idx) {
    case 1:
        playlistname = InputBox("Rename the playlist: "+mytab[ind].tabname, "Rename a playlist", mytab[ind].tabname);
        if(!playlistname || playlistname == "") playlistname = mytab[ind].tabname;
        if (playlistname.length > 1 || (playlistname.length == 1 && (playlistname >= "a" && playlistname <= "z") || (playlistname >= "A" && playlistname <= "Z") || (playlistname >= "0" && playlistname <= "9"))) {
            mytab[ind].tabname = playlistname;
            fb.RenamePlaylist(ind, playlistname);
            window.Repaint();
        }
        break;
    case 2:
		fb.RunMainMenuCommand("File/Save Playlist...");
        break;
    case 3:
		fb.RunMainMenuCommand("File/Load Playlist...");
        break;
    case 4:
		fb.RunMainMenuCommand("View/Playlist Manager");
        break;
    case 98:
        window.ShowProperties();
        break;
    case 99:
        window.ShowConfigure();
        break;
    }
    _menu.Dispose();
    return true;
}

//==========================================================================/ refresh_playlists
function refresh_playlists() {
    var i;
    
    scrolltabs = false;
    CONST_tab_left_padding = 00;
    CONST_tab_right_padding = 18;

    // vidage (RAZ) tableau des playlist
    mytab.splice(0, mytab.length);

    // init of the tabs (one tab per playlist found)
    for (i = 0; i < fb.PlaylistCount; i++) {
        mytab.push(new tab);
        mytab[i].create(fb.GetPlaylistName(i), i);
    }
    // adjusting the width of the tabs depending of the free space available (width of the book - width of the newtab button ...)
    if (((CONST_tab_width_default + 1) * mytab.length + CONST_new_tab_button_width) > ww - (CONST_tab_left_padding + CONST_tab_right_padding)) {
        CONST_tab_width = ((ww - (CONST_tab_left_padding + CONST_tab_right_padding) - CONST_new_tab_button_width - mytab.length + 1) / mytab.length) - 0;
    } else {
        CONST_tab_width = CONST_tab_width_default;
    }

    // force tab width to the minimal width if smaller (then horizontal scroll will be activated!)
    if (CONST_tab_width <= CONST_tab_width_minimal) {
        scrolltabs = true;
        CONST_tab_left_padding = 18;
        CONST_tab_right_padding = 53;
        CONST_tab_width = CONST_tab_width_minimal;
    } else {
        scrolltabs = false;
        CONST_tab_left_padding = 00;
        CONST_tab_right_padding = 18;
        //pos=0;
    }

    // changing focus on the new active sheet = this new created one!
    for (i = 0; i < mytab.length; i++) {
        mytab[i].status = 0;
    }
	
    window.Repaint();
}

//==========================================================================/ rbtn_down
function on_mouse_rbtn_down(x, y) {
    //playlist_context_menu(x, y);
    var i;
    if (x > CONST_tab_left_padding && x < ww - CONST_tab_right_padding) {
        for (i = 0; i < mytab.length; i++) {
            mytab[i].checkstate("right", x, y, i);
        }
    }
}

//==========================================================================/ on_mouse_right_button
function on_mouse_rbtn_up(x, y) {
    return true;
}

//==========================================================================/ mouse_wheel
function on_mouse_wheel(delta) {
    var i;
    var total_area;
    var visible_area;
    var delta_area_right;
    var delta_area_left;
    var scroll_area_right;
    var scroll_area_left;
    var ex_pos = pos;
	
    total_area = bt_w * mytab.length;
    visible_area = ww - CONST_tab_left_padding - CONST_tab_right_padding;
    if (total_area > visible_area) {
        delta_area_right = total_area - visible_area + pos;
        scroll_area_right = delta_area_right / scrollstep;
        if (scroll_area_right < 1) {
            scroll_area_right = delta_area_right;
        } else {
            scroll_area_right = scrollstep;
        }

        delta_area_left = pos * -1;
        scroll_area_left = delta_area_left / scrollstep;
        if (scroll_area_left < 1) {
            scroll_area_left = delta_area_left;
        } else {
            scroll_area_left = scrollstep;
        }

    } else {
        delta_area_right = 0;
        scroll_area_right = 0;
        delta_area_left = 0;
        scroll_area_left = 0;
    }

    if (delta < 0) {
        pos = pos - scroll_area_right;
    } else {
        pos = pos + scroll_area_left;
    }

    // update the tabs position
    for (i = 0; i < mytab.length; i++) {
        mytab[i].x = mytab[i].x - ex_pos + pos;
        mytab[i].bt_close.x = mytab[i].bt_close.x - ex_pos + pos;
    }
    on_mouse_move(mouse_x, mouse_y);
    window.Repaint();
}

// ===============================================================================/ Refresh BG
function RefreshBG() {
    window.Repaint();
}
